using System;

namespace com.swvoyages.reservation {

	///
	/// <summary>L'interface <code>ReservationLookup</code> dfinit la 
	/// manire de rechercher un partenaire durant le processus de rservation.
	/// </summary>
	///
	public interface ReservationLookup {

		///
		/// <summary>Renvoie le tableau des coordonnes de rservation 
		/// du partenaire trouv. Celui-ci doit implmenter le service
		/// type dont le nom est pass en paramtre et ses coordonnes
		/// sont recherches dans le registre UDDI dont l'URL de l'API 
		/// de recherche est communique.</summary>
		///
		/// <param name="inquireURL">URL de l'API de recherche du
		///	registre UDDI slectionn</param>
		/// <param name="tModelName">nom du service type dont une
		///	implmentation est recherche</param>
		///
		/// <returns>String[0] URL du fichier WSDL de description du
		/// service type implment - String[1] URL du point d'accs 
		/// au service du partenaire</returns>
		///
		/// <exception cref="ReservationException">lance si une anomalie
		///	se produit durant la recherche d'un partenaire</exception>
		///
		String[] lookup(String inquireURL, String tModelName);
	}
}